TITLE "Generation of Black Oil Tables"

-- Define a simple 3-stage separation process:

TEMP 38 C, PRES 40.0 barg, SEPARATOR Primary
TEMP 38 C, PRES 12.5 barg, SEPARATOR Secondary
TEMP 15 C, PRES  0.0 barg, SEPARATOR StockTank

PROCESS Three-Stage
STAGE Primary   : SEPARATOR Primary
STAGE Secondary : SEPARATOR Secondary
STAGE StockTank : SEPARATOR StockTank

-- Define a black oil collector:

COLLECTOR Oil_Rim

-- Set the depth, temperature, pressure, and composition to
-- those at the middle of the reservoir:

DEPTH   3350 m
TEMP    93.5 C    STORE Tr
PRES  338.78 bar  STORE Pr
MIX FEED 1 MOLE Predicted_3350_m_Oil ; from earlier segregation experiment

-- Calculate saturation pressure:

SATP

-- Perform either a DLE or a CVD experiment to collect saturated samples at
-- the bubble point and lower pressures. Choose whichever experiment best
-- represents the anticipated reservoir process. In this case, a CVD:

CVD ID "CVD of Predicted_3350_m_Oil to Collect Black Oil Samples"
PRES         EQL        EQV         LDEN       GDEN      LVIS    GVIS      IFT  
(bar)                              (kg/m3)    (kg/m3)    (cp)    (cp)    (dyn/cm)
             Oil_Rim    Oil_Rim ; leave PRES blank for the reference (i.e., saturation) pressure
220          Oil_Rim    Oil_Rim
200          Oil_Rim    Oil_Rim
180          Oil_Rim    Oil_Rim
160          Oil_Rim    Oil_Rim
140          Oil_Rim    Oil_Rim
120          Oil_Rim    Oil_Rim
100          Oil_Rim    Oil_Rim
 80          Oil_Rim    Oil_Rim
 60          Oil_Rim    Oil_Rim
 40          Oil_Rim    Oil_Rim
 20          Oil_Rim    Oil_Rim
 10          Oil_Rim    Oil_Rim
  5          Oil_Rim    Oil_Rim
  2          Oil_Rim    Oil_Rim
  1.01325    Oil_Rim    Oil_Rim ; should yield a dead oil
END

-- To collect saturated samples above the bubble point, perform a "reverse DLE,"
-- starting from the saturation pressure and continuing to just shy of a
-- convergence pressure:

MIX FEED 1 MOLE Predicted_3350_m_Oil
SATP

DEFINE Keep-Phase NFL
DEFINE Command "COLLECT Oil_Rim NFL NFV"

PRES 250 bar, INCLUDE "Reverse DLE.inc"
PRES 275 bar, INCLUDE "Reverse DLE.inc"
PRES 300 bar, INCLUDE "Reverse DLE.inc"
PRES 325 bar, INCLUDE "Reverse DLE.inc"
PRES 350 bar, INCLUDE "Reverse DLE.inc"
PRES 375 bar, INCLUDE "Reverse DLE.inc"
PRES 400 bar, INCLUDE "Reverse DLE.inc"
PRES 425 bar, INCLUDE "Reverse DLE.inc"
PRES 450 bar, INCLUDE "Reverse DLE.inc"
PRES 475 bar, INCLUDE "Reverse DLE.inc"
PRES 500 bar, INCLUDE "Reverse DLE.inc"

-- Collect saturated samples at the convergence pressure:

MIX FEED 0.5 NFL 0.5 NFV
CONP
COLLECT Oil_Rim NFL NFV 

-- Collect an injection gas (usable in Eclipse 100)

MIX FEED Lab3_Swelling_Gas
TEMP RESTORE Tr
PRES RESTORE Pr
FLASH
COLLECT Oil_Rim EQV

-- Start the black oil figures on a new page in the LaTeX report:

CLEARFIGURES

-- Generate the black oil tables:

BLACK-OIL ID "Black Oil Tables from Predicted_3350_m_Oil at 93.5 C\nUsing Three-Stage Separation Process"
  COLLECTOR    Oil_Rim      ; must specify the collector to use
  PROCESS      Three-Stage  ; must specify the process to use
  PRES (bar)   525 550      ; additional pressures to include (optional)
  UNITS METRIC ; the default, as opposed to FIELD or LAB
  ECLIPSE YES  ; write an ECL file with black oil tables in Eclipse format
  SENSOR YES   ; write an SSR file with black oil tables in Sensor format
  PLOTTING ON  ; plot a collection of saturated black oil curves
END
